defmodule Reseau.Serveur do
  @moduledoc """
  Une simple tâche gérant l'écoute sur un port précisé.
  """

  use Task

  require Logger

  @doc """
  Création du processus.
  """
  def start_link(options) do
    port = Keyword.fetch!(options, :port)
    Task.start_link(__MODULE__, :écouter_port, [port])
  end

  def écouter_port(port) do
    {:ok, socket} =
      :gen_tcp.listen(
        port,
        [:binary, packet: :line, active: false, reuseaddr: true]
      )

    Logger.info("Le serveur est démarré et écoute sur le port #{port}.")
    écouter_connexions(socket)
  end

  defp écouter_connexions(socket) do
    {:ok, client} = :gen_tcp.accept(socket)
    Logger.info("Un nouveau client #{inspect(client)} est à présent connecté.")

    {:ok, processus} =
      DynamicSupervisor.start_child(Reseau.ClientSupervisor, {Reseau.Client, client})

    :ok = :gen_tcp.controlling_process(client, processus)
    écouter_connexions(socket)
  end
end
